--local ConstructionInit = CursorBuilding.Init
local clear_enum_flags = const.efWalkable + const.efApplyToGrids + const.efCollision + const.efBakedTerrainDecal

function CursorBuilding:Init()	
	--ConstructionInit(self)
	self.entity = self.entity or self.template:GetEntity()
	self:ChangeEntity(self.entity)
	
	if self.dome_skin then
		self.template.AttachConfigurableAttaches(self, self.dome_skin[2])
	else
		self.template.AttachConfigurableAttaches(self, self.template.configurable_attaches)
	end
	
	if not self.rocket and not IsKindOf(self.template, "RocketLandingSite") then
		AutoAttachObjectsToPlacementCursor(self)
	else
		local rocket_e
		if self.rocket then
		  rocket_e = self.rocket:GetEntity()
		else
			-- [ADDED PART]:start
			-- Permet de prendre en compte les nouvelles Rockets à afficher sur le Cursor de placement
		  	if IsKindOf(self.template, "RDM_SupplyRocketBuilding") then
				rocket_e = self.template.rocket_class
			else
				rocket_e = GetConstructionRocketEntity()
			end
			-- [ADDED PART]:end
		end
		
		local idx = self:GetSpotBeginIndex("idle", "Rocket")
		if idx > -1 then
		  PlaceAtSpot(self, idx, rocket_e, "placementcursor")
		end
	end
	
	self:ForEachAttach(AutoAttachObjectsToPlacementCursor)
	AttachDoors(self, self.entity)
	local cm1, cm2, cm3, cm4
	if self.override_palette then
		if self.entity == "RocketLandingSite" and self.rocket then
		  cm1, cm2, cm3, cm4 = DecodePalette(self.override_palette, self.rocket:GetColorScheme())
		else
		  cm1, cm2, cm3, cm4 = DecodePalette(self.override_palette)
		end
	end
	
	if self.dome_skin and Presets.DomeSkins[self.dome_skin] and next(Presets.DomeSkins[self.dome_skin].palette) then
		cm1, cm2, cm3, cm4 = DecodePalette(Presets.DomeSkins[self.dome_skin].palette)
	end
	
	if not cm1 then
		cm1, cm2, cm3, cm4 = GetBuildingColors(GetCurrentColonyColorScheme(), self.template)
	end
	
	Building.SetPalette(self, cm1, cm2, cm3, cm4)
	if self.template:IsKindOf("SpireBase") then
		local e = SpireBase.GetFrameEntity(self, self.template)
		if e ~= "none" and IsValidEntity(e) then
			local frame = PlaceObject("SpireFrame")
			frame:ChangeEntity(e)
			frame:SetAttachOffset(point(-1, 0, 4392))
			self:Attach(frame, self:GetSpotBeginIndex("Origin"))
		end
	end
	
	local shape = GetEntityOutlineShape(self.entity)
	for i = 1, #shape do
		local q, r = shape[i]:xy()
		local x, y = HexToWorld(q, r)
		local offset = point(x, y, 30)
		local tile = PlaceObject("GridTile", nil, const.cofComponentAttach)
		self:Attach(tile)
		tile:SetAttachOffset(offset)
	end
	
	if IsKindOf(self.template, "LifeSupportGridObject") then
		SetObjWaterMarkers(self, true)
	end
	
	if self.template.show_decals_on_placement then
	local att = self:GetAttaches()
		for i = 1, #att do
			if att[i]:GetEnumFlags(const.efBakedTerrainDecal) ~= 0 then
				att[i]:SetEnumFlags(const.efVisible)
			end
		end
	end
	
	self:ClearHierarchyEnumFlags(clear_enum_flags)
	if self.template.lights_on_during_placement then
		self:SetIsNightLightPossible(true, true)
	else
		self:ClearHierarchyGameFlags(const.gofNightLightsEnabled)
	end
end